#!/usr/bin/env bash
source $MINER_DIR/$CUSTOM_MINER/h-manifest.conf

algo='aleo'
version="3.0.6"
stats=""
unit="S/s"
khs=0

khs=$(tail -n 100 /var/log/miner/custom/aleominer1.log |grep "Speed(S/s)" | awk 'END {print}'| awk '{print $3}')
khs=$(echo "scale=5; $khs / 1000" | bc)

khs_num=$(echo "$khs" | jq -R . | jq -s 'map(tonumber)[0]')

stats=$(jq -nc --argjson khs "$khs_num" \
	--arg hs_units "$unit" \
	--arg ver "$version" \
	--arg algo "$algo" \
	'{"khs":$khs, "hs_units":$hs_units, "ver":$ver, "algo":$algo}')


echo "$stats"
